/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed*0.3
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

vec2 rotate(in vec2 p, in float t)
{
   return p*cos(-t)+vec2(p.y, -p.x)*sin(-t);
}

float sdTorus(in vec3 p, in vec2 t)
{
   vec2 q = vec2(length(p.xz)-t.x, p.y);
   return length(q)-t.y;
}

void main(void)
{
   vec2 p2 = (2.0*gl_FragCoord.xy-iResolution.xy)/iResolution.y;
   vec3 col = vec3(0.0);
   const float steps = 30.0;
   float pe = 3.0;
   for(float i = 0.0; i < steps; i++)
   {
      float r = i/steps;
      float z = -1.0+2.0*r*r;
      z *= 3.0;
      float s = pe/(pe+z);
      vec3 p3 = vec3(p2*s, z);
      p3.zx = rotate(p3.zx, iGlobalTime*0.521);
      p3.yz = rotate(p3.yz, iGlobalTime*0.632);
      p3.x += 0.45;
      float de = sdTorus ( p3,
         vec2(0.70*cos(iGlobalTime*1.678)+1.2,
              0.35*(sin(iGlobalTime*1.234)+1.0)) );
      de = smoothstep(0.08,0.0,de);
      if (de > 0.0 && de < 0.5)
       {
         col = vec3(r*0.5+0.5, 1.0-r, r*(sin(iGlobalTime*1.987)*2.0-1.0))*(1.0-de*2.0);
       }
    }
   gl_FragColor = vec4(col, length(col)*100.0);
}